
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Dec 26 17:51:02 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief HMAC external application ATP tests  
   *
   *  \version CRYS_Ext_ATP_HMAC_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2006 by Discretix Technologies Ltd.
   *           All Rights reserved
   */



/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_HMAC_Acceptance.h"
#include "CRYS_Ext_ATP_HMAC_Acceptance_test_vectors.h"
#include "CRYS_HOST_TST_HMAC.h"

#include "DX_VOS_Mem.h"


/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/
extern char FailureFunctionNameOut[FailureFunctionName_K_Size];
/***** Private function prototype ******/
/******** Public Functions **********/
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   char        *FailureFunctionNameOut_ptr,        
									   DxUint32_t   FuncNameMaxSize);

/******** Private Functions ******/

/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_HMAC_NON_integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for HMAC non integrated function,
*  implemented as external SEP application                          .
*  HASH modes                   - SHA1
*  Vector sizes used (in bytes) - 1536                                 
* Algorithm:       
* 1. Call the SEPQA_HMAC_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_HMAC_NON_integrated ( void )
{

    /*** TST Variables Definitions ****/
    int                     	TST_index = 0; 
    CRYSError_t             	TST_TestStatus=0;
	char                    	TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_HMAC_NON_integrated";
    


    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ExtApp_ATP_HMAC_NON_integrated Tests ******** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
	SEP_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d]\n",SEP_HMAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
    CRYS_ATP_TST_PrintHASHType(CRYS_HASH_SHA1_mode);

	TST_TestStatus = TESTPASS;

	TST_ATP_Error = SEPQA_HMAC_NotIntegrated(SEP_HMAC_Acceptance_TestData[TST_index].TST_OperationMode,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_key,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_keySize,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_input_data,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_input_dataSize,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
											 SEP_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize,
											 FailureFunctionNameOut,
											 FailureFunctionName_K_Size);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_HMAC_NotIntegrated",FailureFunctionNameOut,TST_MasterTestName);                   


	return TST_TestStatus;
} /*End of test*/



/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/

/***************************
* Function Name:                                                           
*  CRYS_ExtApp_ATP_HMAC_Integrated      
*  
* Inputs:
*  None
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
*  This function Is a Acceptance test for HMAC integrated function,
*  implemented as external SEP application                          .
*  HASH modes                   - SHA1
*  Vector sizes used (in bytes) - 1536                                 
* Algorithm:       
* 1. Call the SEPQA_HMAC_NotIntegrated function to execute test
* 2. Verify function succeded according to the returned error code
*
**************************/                                
CRYSError_t CRYS_ExtApp_ATP_HMAC_Integrated ( void )
{

    /*** TST Variables Definitions ****/
    int         TST_index = 0;
    CRYSError_t TST_TestStatus=0;
    char        TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ExtApp_ATP_HMAC_Integrated";

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  ** CRYS_ExtApp_ATP_HMAC_Integrated Tests ******** \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"  *********************** \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
	SEP_HMAC_Acceptance_TestData[TST_index].TST_OperationMode = CRYS_HASH_SHA1_mode;

    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," %s [test 1A.%d] \n",SEP_HMAC_Acceptance_TestData[TST_index].TST_Name,TST_index));
    CRYS_ATP_TST_PrintHASHType(SEP_HMAC_Acceptance_TestData[TST_index].TST_OperationMode);

    /* calling the HMAC function */
    /*---------------------------*/

	TST_ATP_Error = SEPQA_HMAC_Integrated(SEP_HMAC_Acceptance_TestData[TST_index].TST_OperationMode,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_key,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_keySize,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_input_data,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_input_dataSize,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_output_data,
										  SEP_HMAC_Acceptance_TestData[TST_index].TST_SHA1_Expected_dataSize,
										  FailureFunctionNameOut,
									      FailureFunctionName_K_Size);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_ATP_Error,"SEPQA_HMAC_Integrated",FailureFunctionNameOut,TST_MasterTestName);                   


	return TST_TestStatus;            
            
} /*End of test*/

/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/



